import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:amethyst_geode', {
        onTick({ block }) {
            const shard = new ItemStack('minecraft:amethyst_shard', 1)
            block.dimension.spawnItem(shard, block.center())
        },
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:open_amethyst_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:amethyst_geode.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:citrine_geode', {
        onTick({ block }) {
            const shard = new ItemStack('v360:citrine_shard', 1)
            block.dimension.spawnItem(shard, block.center())
        },
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:open_citrine_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:citrine_geode.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:garnet_geode', {
        onTick({ block }) {
            const shard = new ItemStack('v360:garnet_shard', 1)
            block.dimension.spawnItem(shard, block.center())
        },
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:open_garnet_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:garnet_geode.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:jade_geode', {
        onTick({ block }) {
            const shard = new ItemStack('v360:jade_shard', 1)
            block.dimension.spawnItem(shard, block.center())
        },
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:open_jade_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:jade_geode.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:closed_amethyst_geode', {
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:closed_amethyst_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:closed_amethyst_geode_block.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:closed_citrine_geode', {
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:closed_citrine_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:closed_citrine_geode_block.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:closed_garnet_geode', {
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:closed_garnet_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:closed_garnet_geode_block.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:closed_jade_geode', {
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            const spawnItemStack = new ItemStack('v360:closed_jade_geode', 1)
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const itemGeode = data.dimension.getEntities({ type: 'minecraft:item', name: 'tile.v360:closed_jade_geode_block.name', closest: 1 })
            if (isPickaxe && player.getGameMode() !== "creative" && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
            else if (isPickaxe && player.getGameMode() !== "creative" && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemGeode[0].kill()
                system.run(() => {
                    block.dimension.spawnItem(spawnItemStack, block.center())
                })
            }
        }
    })
})